/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.serverlist.gui;

import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import net.creeperhost.minetogether.serverlist.data.Server;
import net.creeperhost.minetogether.serverlist.gui.JoinMultiplayerScreenPublic;
import net.creeperhost.minetogether.serverlist.gui.ServerDataPublic;
import net.creeperhost.minetogether.util.Countries;
import net.creeperhost.minetogether.util.EnumFlag;
import net.creeperhost.polylib.client.screen.ScreenHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PublicServerEntry
extends ServerSelectionList.Entry {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final ServerData serverData;
    private ServerSelectionList serverSelectionList;
    private JoinMultiplayerScreenPublic joinMultiplayerScreen;
    private String lastIconB64;
    private final ResourceLocation iconLocation;
    private static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LogUtils.getLogger())).build());
    private final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/server_selection.png");
    private final Component CANT_RESOLVE_TEXT = new TranslatableComponent("multiplayer.status.cannot_resolve").m_130940_(ChatFormatting.DARK_RED);
    private final Component NO_CONNECTION_TOOLTIP = new TranslatableComponent("multiplayer.status.no_connection");
    private final Component CANT_CONNECT_TEXT = new TranslatableComponent("multiplayer.status.cannot_connect").m_130940_(ChatFormatting.DARK_RED);
    private final Component PINGING_TOOLTIP = new TranslatableComponent("multiplayer.status.pinging");
    private final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    private long lastClickTime;
    private DynamicTexture icon;
    private ResourceLocation flags = new ResourceLocation("minetogether", "textures/flags/flags.png");

    public PublicServerEntry(JoinMultiplayerScreenPublic joinMultiplayerScreen, ServerSelectionList serverSelectionList, ServerData serverData) {
        this.serverData = serverData;
        this.joinMultiplayerScreen = joinMultiplayerScreen;
        this.serverSelectionList = serverSelectionList;
        this.iconLocation = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)serverData.f_105363_) + "/icon");
        AbstractTexture abstractTexture = this.minecraft.m_91097_().m_174786_(this.iconLocation, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
        if (abstractTexture != MissingTextureAtlasSprite.m_118080_() && abstractTexture instanceof DynamicTexture) {
            this.icon = (DynamicTexture)abstractTexture;
        }
    }

    public void m_6311_(PoseStack poseStack, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
        List list5;
        TranslatableComponent component5;
        int z;
        if (!this.serverData.f_105369_) {
            this.serverData.f_105369_ = true;
            this.serverData.f_105366_ = -2L;
            this.serverData.f_105365_ = TextComponent.f_131282_;
            this.serverData.f_105364_ = TextComponent.f_131282_;
            THREAD_POOL.submit(() -> {
                try {
                    this.joinMultiplayerScreen.m_99731_().m_105459_(this.serverData, () -> this.minecraft.execute(this::updateServerList));
                }
                catch (UnknownHostException var2) {
                    this.serverData.f_105366_ = -1L;
                    this.serverData.f_105365_ = this.CANT_RESOLVE_TEXT;
                }
                catch (Exception var3) {
                    this.serverData.f_105366_ = -1L;
                    this.serverData.f_105365_ = this.CANT_CONNECT_TEXT;
                }
            });
        }
        boolean bl2 = false;
        this.minecraft.f_91062_.m_92883_(poseStack, this.serverData.f_105362_, (float)(k + 32 + 3), (float)(j + 1), 0xFFFFFF);
        List list = this.minecraft.f_91062_.m_92923_((FormattedText)this.serverData.f_105365_, l - 32 - 2);
        for (int p = 0; p < Math.min(list.size(), 2); ++p) {
            Font var10000 = this.minecraft.f_91062_;
            FormattedCharSequence var10002 = (FormattedCharSequence)list.get(p);
            float var10003 = k + 32 + 3;
            int var10004 = j + 12;
            this.minecraft.f_91062_.getClass();
            var10000.m_92877_(poseStack, var10002, var10003, (float)(var10004 + 9 * p), 0x808080);
        }
        Component component = bl2 ? this.serverData.f_105368_.m_6881_().m_130940_(ChatFormatting.RED) : this.serverData.f_105364_;
        int q = this.minecraft.f_91062_.m_92852_((FormattedText)component);
        this.minecraft.f_91062_.m_92889_(poseStack, component, (float)(k + l - q - 15 - 2), (float)(j + 1), 0x808080);
        int r = 0;
        if (bl2) {
            z = 5;
            component5 = new TranslatableComponent("");
            list5 = this.serverData.f_105370_;
        } else if (this.serverData.f_105369_ && this.serverData.f_105366_ != -2L) {
            z = this.serverData.f_105366_ < 0L ? 5 : (this.serverData.f_105366_ < 150L ? 0 : (this.serverData.f_105366_ < 300L ? 1 : (this.serverData.f_105366_ < 600L ? 2 : (this.serverData.f_105366_ < 1000L ? 3 : 4))));
            if (this.serverData.f_105366_ < 0L) {
                component5 = this.NO_CONNECTION_TOOLTIP;
                list5 = Collections.emptyList();
            } else {
                component5 = new TranslatableComponent("multiplayer.status.ping", new Object[]{this.serverData.f_105366_});
                list5 = this.serverData.f_105370_;
            }
        } else {
            r = 1;
            z = (int)(Util.m_137550_() / 100L + (long)(i * 2) & 7L);
            if (z > 4) {
                z = 8 - z;
            }
            component5 = this.PINGING_TOOLTIP;
            list5 = Collections.emptyList();
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(k + l - 15), (int)j, (float)(r * 10), (float)(176 + z * 8), (int)10, (int)8, (int)256, (int)256);
        String string = this.serverData.m_105388_();
        if (!Objects.equals(string, this.lastIconB64)) {
            if (this.uploadServerIcon(string)) {
                this.lastIconB64 = string;
            } else {
                this.serverData.m_105383_((String)null);
                this.updateServerList();
            }
        }
        if (this.icon != null) {
            this.drawIcon(poseStack, k, j, this.iconLocation);
        } else {
            this.drawIcon(poseStack, k, j, this.ICON_MISSING);
        }
        int aa = n - k;
        int ab = o - j;
        if (aa >= l - 15 && aa <= l - 5 && ab >= 0 && ab <= 8) {
            this.joinMultiplayerScreen.m_99707_(Collections.singletonList(component5));
        } else if (aa >= l - q - 15 - 2 && aa <= l - 15 - 2 && ab >= 0 && ab <= 8) {
            this.joinMultiplayerScreen.m_99707_(list5);
        }
        if (this.minecraft.f_91066_.f_92051_ || bl) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.ICON_OVERLAY_LOCATION);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)k, (int)j, (int)(k + 32), (int)(j + 32), (int)-1601138544);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int ac = n - k;
            int ad = o - j;
            if (this.canJoin()) {
                if (ac < 32 && ac > 16) {
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)k, (int)j, (float)0.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                } else {
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)k, (int)j, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                }
            }
            if (i < this.joinMultiplayerScreen.m_99732_().m_105445_() - 1) {
                if (ac < 16 && ad > 16) {
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)k, (int)j, (float)64.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                } else {
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)k, (int)j, (float)64.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                }
            }
        }
        if (this.getServerData() != null) {
            Server server = this.getServerData().server;
            EnumFlag flag = server.getFlag();
            String applicationURL = server.applicationUrl;
            if (flag != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.flags);
                int flagWidth = 16;
                int flagHeight = flag.height / (flag.width / flagWidth);
                ScreenHelper.drawScaledCustomSizeModalRect((int)(k + l - 5 - flagWidth), (int)(j + 30 - flagHeight), (float)flag.x, (float)flag.y, (int)flag.width, (int)flag.height, (int)flagWidth, (int)flagHeight, (float)512.0f, (float)512.0f);
                if (n >= k + l - 5 - flagWidth && n <= k + l - 5 && o >= j - 10 - flagHeight && o <= j - flagHeight + flagHeight) {
                    ArrayList<TranslatableComponent> tooltipList = new ArrayList<TranslatableComponent>();
                    String countryName = Countries.COUNTRIES.getOrDefault(flag.name(), flag.name());
                    tooltipList.add(new TranslatableComponent(countryName));
                    this.joinMultiplayerScreen.m_99707_(tooltipList);
                }
            }
        }
    }

    private boolean uploadServerIcon(@Nullable String string) {
        if (string == null) {
            this.minecraft.m_91097_().m_118513_(this.iconLocation);
            if (this.icon != null && this.icon.m_117991_() != null) {
                this.icon.m_117991_().close();
            }
            this.icon = null;
        } else {
            try {
                NativeImage nativeImage = NativeImage.m_85060_((String)string);
                Validate.validState((nativeImage.m_84982_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((nativeImage.m_85084_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                if (this.icon == null) {
                    this.icon = new DynamicTexture(nativeImage);
                } else {
                    this.icon.m_117988_(nativeImage);
                    this.icon.m_117985_();
                }
                this.minecraft.m_91097_().m_118495_(this.iconLocation, (AbstractTexture)this.icon);
            }
            catch (Throwable var3) {
                LOGGER.error("Invalid icon for server {} ({})", (Object)this.serverData.f_105362_, (Object)this.serverData.f_105363_, (Object)var3);
                return false;
            }
        }
        return true;
    }

    private boolean canJoin() {
        return true;
    }

    public void updateServerList() {
        this.joinMultiplayerScreen.m_99732_().m_105442_();
    }

    protected void drawIcon(PoseStack poseStack, int i, int j, ResourceLocation resourceLocation) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.m_69478_();
        GuiComponent.m_93133_((PoseStack)poseStack, (int)i, (int)j, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        RenderSystem.m_69461_();
    }

    public ServerDataPublic getServerData() {
        if (this.serverData instanceof ServerDataPublic) {
            return (ServerDataPublic)this.serverData;
        }
        return null;
    }

    public boolean m_6375_(double d, double e, int i) {
        double f = d - (double)this.serverSelectionList.m_5747_();
        if (f <= 32.0 && f < 32.0 && f > 16.0 && this.canJoin()) {
            this.joinMultiplayerScreen.m_99700_(this);
            this.joinMultiplayerScreen.m_99729_();
            return true;
        }
        this.joinMultiplayerScreen.m_99700_(this);
        if (Util.m_137550_() - this.lastClickTime < 250L) {
            this.joinMultiplayerScreen.m_99729_();
        }
        this.lastClickTime = Util.m_137550_();
        return false;
    }

    public Component m_142172_() {
        return new TranslatableComponent("narrator.select", new Object[]{this.serverData.f_105362_});
    }
}

